/*
 * @(#) $Id: wpbm.c 352 2024-12-28 21:09:42Z leres $ (XSE)
 *
 * Copyright (c) 1999, 2000, 2008, 2009, 2010, 2015, 2017, 2024
 *	Craig Leres
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that: (1) source code
 * distributions retain the above copyright notice and this paragraph
 * in its entirety, and (2) distributions including binary code include
 * the above copyright notice and this paragraph in its entirety in
 * the documentation or other materials provided with the distribution
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
 */

#include <sys/types.h>
#include <sys/stat.h>

#include <fcntl.h>
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <ppm.h>

#include "wpbm.h"

int
parsepbm(/* const */ char *image, int *wp, int *hp, struct timespec *mtimp)
{
	FILE *f;
	pixval maxval;
	int format;
	struct stat sbuf;

	f = pm_openr(image);
	if (f == NULL)
		return (0);

	/* XXX ignore errors */
	if (mtimp != NULL && fstat(fileno(f), &sbuf) >= 0)
		*mtimp = sbuf.st_mtim;

	ppm_readppminit(f, wp, hp, &maxval, &format);

	(void)fclose(f);
	return (0);
}
